/* hgdpGeo.c was originally generated by the autoSql program, which also 
 * generated hgdpGeo.h and hgdpGeo.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "hgdpGeo.h"


void hgdpGeoStaticLoad(char **row, struct hgdpGeo *ret)
/* Load a row from hgdpGeo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->ancestralAllele = row[4][0];
ret->derivedAllele = row[5][0];
sqlFloatArray(row[6], ret->popFreqs, 53);
}

struct hgdpGeo *hgdpGeoLoad(char **row)
/* Load a hgdpGeo from row fetched with select * from hgdpGeo
 * from database.  Dispose of this with hgdpGeoFree(). */
{
struct hgdpGeo *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->ancestralAllele = row[4][0];
ret->derivedAllele = row[5][0];
sqlFloatArray(row[6], ret->popFreqs, 53);
return ret;
}

struct hgdpGeo *hgdpGeoLoadAll(char *fileName) 
/* Load all hgdpGeo from a whitespace-separated file.
 * Dispose of this with hgdpGeoFreeList(). */
{
struct hgdpGeo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = hgdpGeoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct hgdpGeo *hgdpGeoLoadAllByChar(char *fileName, char chopper) 
/* Load all hgdpGeo from a chopper separated file.
 * Dispose of this with hgdpGeoFreeList(). */
{
struct hgdpGeo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = hgdpGeoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct hgdpGeo *hgdpGeoCommaIn(char **pS, struct hgdpGeo *ret)
/* Create a hgdpGeo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hgdpGeo */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
sqlFixedStringComma(&s, &(ret->ancestralAllele), sizeof(ret->ancestralAllele));
sqlFixedStringComma(&s, &(ret->derivedAllele), sizeof(ret->derivedAllele));
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<53; ++i)
    {
    ret->popFreqs[i] = sqlFloatComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void hgdpGeoFree(struct hgdpGeo **pEl)
/* Free a single dynamically allocated hgdpGeo such as created
 * with hgdpGeoLoad(). */
{
struct hgdpGeo *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freez(pEl);
}

void hgdpGeoFreeList(struct hgdpGeo **pList)
/* Free a list of dynamically allocated hgdpGeo's */
{
struct hgdpGeo *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    hgdpGeoFree(&el);
    }
*pList = NULL;
}

void hgdpGeoOutput(struct hgdpGeo *el, FILE *f, char sep, char lastSep) 
/* Print out hgdpGeo.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->ancestralAllele);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->derivedAllele);
if (sep == ',') fputc('"',f);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<53; ++i)
    {
    fprintf(f, "%g", el->popFreqs[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

