/* members.h was originally generated by the autoSql program, which also 
 * generated members.c and members.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef MEMBERS_H
#define MEMBERS_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define MEMBERS_NUM_COLS 10

struct members
/* GSID HIV members */
    {
    struct members *next;  /* Next in singly linked list. */
    char *email;	/* email serves as user id */
    char *password;	/* password */
    char activated[2];	/* account activated? Y or N */
    char *name;	/* name */
    char *phone;	/* phone number */
    char *institution;	/* institution (if any) */
    char *type;	/* type of membership */
    float amountPaid;	/* amount paid */
    char *datePaid;	/* date paid in paypal format */
    char expireDate[11];	/* expiration date */
    };

void membersStaticLoad(char **row, struct members *ret);
/* Load a row from members table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct members *membersLoad(char **row);
/* Load a members from row fetched with select * from members
 * from database.  Dispose of this with membersFree(). */

struct members *membersLoadAll(char *fileName);
/* Load all members from whitespace-separated file.
 * Dispose of this with membersFreeList(). */

struct members *membersLoadAllByChar(char *fileName, char chopper);
/* Load all members from chopper separated file.
 * Dispose of this with membersFreeList(). */

#define membersLoadAllByTab(a) membersLoadAllByChar(a, '\t');
/* Load all members from tab separated file.
 * Dispose of this with membersFreeList(). */

struct members *membersLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all members from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with membersFreeList(). */

void membersSaveToDb(struct sqlConnection *conn, struct members *el, char *tableName, int updateSize);
/* Save members as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct members *membersCommaIn(char **pS, struct members *ret);
/* Create a members out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new members */

void membersFree(struct members **pEl);
/* Free a single dynamically allocated members such as created
 * with membersLoad(). */

void membersFreeList(struct members **pList);
/* Free a list of dynamically allocated members's */

void membersOutput(struct members *el, FILE *f, char sep, char lastSep);
/* Print out members.  Separate fields with sep. Follow last field with lastSep. */

#define membersTabOut(el,f) membersOutput(el,f,'\t','\n');
/* Print out members as a line in a tab-separated file. */

#define membersCommaOut(el,f) membersOutput(el,f,',',',');
/* Print out members as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* MEMBERS_H */

