/* cgapSage.h was originally generated by the autoSql program, which also 
 * generated cgapSage.c and cgapSage.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2007 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef CGAPSAGE_H
#define CGAPSAGE_H

#define CGAPSAGE_NUM_COLS 14

struct cgapSage
/* Mappings and frequencies for CGAP SAGE tags */
    {
    struct cgapSage *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start in Chromosome */
    unsigned chromEnd;	/* End in Chromosome */
    char *name;	/* Name */
    unsigned score;	/* Score */
    char strand[2];	/* Strand */
    unsigned thickStart;	/* Thick start */
    unsigned thickEnd;	/* Thick end */
    unsigned numLibs;	/* Number of libraries with data for this tag */
    unsigned *libIds;	/* Ids of libraries (foreign keys) */
    unsigned *freqs;	/* Frequency of each tag per library */
    double *tagTpms;	/* Tag per million measurement of each lib */
    unsigned numSnps;	/* Number of class=single SNPs in this region */
    char **snps;	/* List of SNPs */
    };

struct cgapSage *cgapSageLoad(char **row);
/* Load a cgapSage from row fetched with select * from cgapSage
 * from database.  Dispose of this with cgapSageFree(). */

struct cgapSage *cgapSageLoadAll(char *fileName);
/* Load all cgapSage from whitespace-separated file.
 * Dispose of this with cgapSageFreeList(). */

struct cgapSage *cgapSageLoadAllByChar(char *fileName, char chopper);
/* Load all cgapSage from chopper separated file.
 * Dispose of this with cgapSageFreeList(). */

#define cgapSageLoadAllByTab(a) cgapSageLoadAllByChar(a, '\t');
/* Load all cgapSage from tab separated file.
 * Dispose of this with cgapSageFreeList(). */

struct cgapSage *cgapSageCommaIn(char **pS, struct cgapSage *ret);
/* Create a cgapSage out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cgapSage */

void cgapSageFree(struct cgapSage **pEl);
/* Free a single dynamically allocated cgapSage such as created
 * with cgapSageLoad(). */

void cgapSageFreeList(struct cgapSage **pList);
/* Free a list of dynamically allocated cgapSage's */

void cgapSageOutput(struct cgapSage *el, FILE *f, char sep, char lastSep);
/* Print out cgapSage.  Separate fields with sep. Follow last field with lastSep. */

#define cgapSageTabOut(el,f) cgapSageOutput(el,f,'\t','\n');
/* Print out cgapSage as a line in a tab-separated file. */

#define cgapSageCommaOut(el,f) cgapSageOutput(el,f,',',',');
/* Print out cgapSage as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

int cgapSageCmp(const void *va, const void *vb);
/* Compare based on chrom,start,end,name. */

#endif /* CGAPSAGE_H */

