/* ensInfo.h was originally generated by the autoSql program, which also 
 * generated ensInfo.c and ensInfo.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2007 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef ENSINFO_H
#define ENSINFO_H

#define ENSINFO_NUM_COLS 6

struct ensInfo
/* ensembl Genes track additional information */
    {
    struct ensInfo *next;  /* Next in singly linked list. */
    char *name;	/* Ensembl transcript ID */
    char *otherId;	/* other ID */
    char *geneId;	/* Ensembl gene ID */
    char *class;	/* Ensembl gene type */
    char *geneDesc;	/* Ensembl gene description */
    char *status;	/* Ensembl gene confidence */
    };

void ensInfoStaticLoad(char **row, struct ensInfo *ret);
/* Load a row from ensInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct ensInfo *ensInfoLoad(char **row);
/* Load a ensInfo from row fetched with select * from ensInfo
 * from database.  Dispose of this with ensInfoFree(). */

struct ensInfo *ensInfoLoadAll(char *fileName);
/* Load all ensInfo from whitespace-separated file.
 * Dispose of this with ensInfoFreeList(). */

struct ensInfo *ensInfoLoadAllByChar(char *fileName, char chopper);
/* Load all ensInfo from chopper separated file.
 * Dispose of this with ensInfoFreeList(). */

#define ensInfoLoadAllByTab(a) ensInfoLoadAllByChar(a, '\t');
/* Load all ensInfo from tab separated file.
 * Dispose of this with ensInfoFreeList(). */

struct ensInfo *ensInfoCommaIn(char **pS, struct ensInfo *ret);
/* Create a ensInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ensInfo */

void ensInfoFree(struct ensInfo **pEl);
/* Free a single dynamically allocated ensInfo such as created
 * with ensInfoLoad(). */

void ensInfoFreeList(struct ensInfo **pList);
/* Free a list of dynamically allocated ensInfo's */

void ensInfoOutput(struct ensInfo *el, FILE *f, char sep, char lastSep);
/* Print out ensInfo.  Separate fields with sep. Follow last field with lastSep. */

#define ensInfoTabOut(el,f) ensInfoOutput(el,f,'\t','\n');
/* Print out ensInfo as a line in a tab-separated file. */

#define ensInfoCommaOut(el,f) ensInfoOutput(el,f,',',',');
/* Print out ensInfo as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ENSINFO_H */

