/* hubPublic.h was originally generated by the autoSql program, which also 
 * generated hubPublic.c and hubPublic.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef HUBPUBLIC_H
#define HUBPUBLIC_H

#include "jksql.h"
#define HUBPUBLIC_NUM_COLS 7

extern char *hubPublicCommaSepFieldNames;

struct hubPublic
/* Table of public track data hub connections. */
    {
    struct hubPublic *next;  /* Next in singly linked list. */
    char *hubUrl;	/* URL to hub.ra file */
    char *shortLabel;	/* Hub short label. */
    char *longLabel;	/* Hub long label. */
    char *registrationTime;	/* Time first registered */
    unsigned dbCount;	/* Number of databases hub has data for. */
    char *dbList;	/* Comma separated list of databases. */
    char *descriptionUrl;	/* URL to description HTML */
    };

struct hubEntry
// for entries pulled from hubPublic
    {
    struct hubEntry *next;
    char *hubUrl;
    char *shortLabel;
    char *longLabel;
    char *dbList;
    char *errorMessage;
    int id;
    char *descriptionUrl;
    bool tableHasDescriptionField;
    };

void hubPublicStaticLoad(char **row, struct hubPublic *ret);
/* Load a row from hubPublic table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct hubPublic *hubPublicLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all hubPublic from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with hubPublicFreeList(). */

void hubPublicSaveToDb(struct sqlConnection *conn, struct hubPublic *el, char *tableName, int updateSize);
/* Save hubPublic as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct hubPublic *hubPublicLoad(char **row);
/* Load a hubPublic from row fetched with select * from hubPublic
 * from database.  Dispose of this with hubPublicFree(). */

struct hubPublic *hubPublicLoadAll(char *fileName);
/* Load all hubPublic from whitespace-separated file.
 * Dispose of this with hubPublicFreeList(). */

struct hubPublic *hubPublicLoadAllByChar(char *fileName, char chopper);
/* Load all hubPublic from chopper separated file.
 * Dispose of this with hubPublicFreeList(). */

#define hubPublicLoadAllByTab(a) hubPublicLoadAllByChar(a, '\t');
/* Load all hubPublic from tab separated file.
 * Dispose of this with hubPublicFreeList(). */

struct hubPublic *hubPublicCommaIn(char **pS, struct hubPublic *ret);
/* Create a hubPublic out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hubPublic */

void hubPublicFree(struct hubPublic **pEl);
/* Free a single dynamically allocated hubPublic such as created
 * with hubPublicLoad(). */

void hubPublicFreeList(struct hubPublic **pList);
/* Free a list of dynamically allocated hubPublic's */

void hubPublicOutput(struct hubPublic *el, FILE *f, char sep, char lastSep);
/* Print out hubPublic.  Separate fields with sep. Follow last field with lastSep. */

#define hubPublicTabOut(el,f) hubPublicOutput(el,f,'\t','\n');
/* Print out hubPublic as a line in a tab-separated file. */

#define hubPublicCommaOut(el,f) hubPublicOutput(el,f,',',',');
/* Print out hubPublic as a comma separated list including final comma. */

void hubPublicJsonOutput(struct hubPublic *el, FILE *f);
/* Print out hubPublic in JSON format. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */
struct hubEntry *hubEntryTextLoad(char **row, bool hasDescription);

#endif /* HUBPUBLIC_H */

