/* vegaInfo.h was originally generated by the autoSql program, which also 
 * generated vegaInfo.c and vegaInfo.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2003 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef VEGAINFO_H
#define VEGAINFO_H

struct vegaInfo
/* Vega Genes track additional information */
    {
    struct vegaInfo *next;  /* Next in singly linked list. */
    char *transcriptId;	/* Vega transcript ID */
    char *otterId;	/* otter (Ensembl db) transcript ID */
    char *geneId;	/* Vega gene ID */
    char *method;	/* GTF method field */
    char *geneDesc;	/* Vega gene description */
    };

void vegaInfoStaticLoad(char **row, struct vegaInfo *ret);
/* Load a row from vegaInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct vegaInfo *vegaInfoLoad(char **row);
/* Load a vegaInfo from row fetched with select * from vegaInfo
 * from database.  Dispose of this with vegaInfoFree(). */

struct vegaInfo *vegaInfoLoadAll(char *fileName);
/* Load all vegaInfo from a tab-separated file.
 * Dispose of this with vegaInfoFreeList(). */

struct vegaInfo *vegaInfoCommaIn(char **pS, struct vegaInfo *ret);
/* Create a vegaInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new vegaInfo */

void vegaInfoFree(struct vegaInfo **pEl);
/* Free a single dynamically allocated vegaInfo such as created
 * with vegaInfoLoad(). */

void vegaInfoFreeList(struct vegaInfo **pList);
/* Free a list of dynamically allocated vegaInfo's */

void vegaInfoOutput(struct vegaInfo *el, FILE *f, char sep, char lastSep);
/* Print out vegaInfo.  Separate fields with sep. Follow last field with lastSep. */

#define vegaInfoTabOut(el,f) vegaInfoOutput(el,f,'\t','\n');
/* Print out vegaInfo as a line in a tab-separated file. */

#define vegaInfoCommaOut(el,f) vegaInfoOutput(el,f,',',',');
/* Print out vegaInfo as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* VEGAINFO_H */

