# landmark.sql was originally generated by the autoSql program, which also 
# generated landmark.c and landmark.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#track for regulatory regions and other landmarks from locus experts
CREATE TABLE landmark (
    bin smallint unsigned not null,	# A field to speed indexing
    chrom varchar(255) not null,	# Chromosome
    chromStart int unsigned not null,	# Start position in chrom
    chromEnd int unsigned not null,	# End position in chrom
    name varchar(64) not null,	# name of landmark
    landmarkId int unsigned not null,	# unique ID to identify this landmark
    landmarkType varchar(64) not null,	# type of landmark: HSS, promoter, ..
              #Indices
    INDEX(bin),
    PRIMARY KEY(landmarkId)
);

#attributes associated with a landmark
CREATE TABLE landmarkAttr (
    landmarkId int unsigned not null,	# key into the landmark table
    linkId int unsigned not null,	# key into the landmarkAttrLink table
    attribute varchar(255) not null,	# name of attribute being listed
    attrVal varchar(255) not null,	# value of this landmark attribute
              #Indices
    INDEX(landmarkId)
);

#table to build links for landmarks
CREATE TABLE landmarkAttrLink (
    attrId int unsigned not null,	# key into the landmarkAttr table
    raKey varchar(64) not null,	# key into RA file, tells how to link
    attrAcc varchar(255) not null,	# accession used by link
    displayVal varchar(255) not null,	# how to display if different from acc
              #Indices
    INDEX(attrId)
);
